#ifndef SST_SEP_ATP_SPECIALDATA_H
#define SST_SEP_ATP_SPECIALDATA_H

#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*Data operations test struct*/
typedef struct TST_ATP_SpecialDataOpAESTestDataStruct{  
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_AESKey[TST_AES_KEY_SIZE];
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxByte_t                    TST_AuthenticatorAESKey[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyType1;
    DxByte_t                    TST_AESKey2[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyType2;
    DxByte_t                    TST_AESKeyTemp[TST_AES_KEY_SIZE];
    SSTAESKeyType_t             TST_AESKeyTypeTemp;
    DxUint32_t                  TST_KeySizeInBytes;
    CRYS_AES_IvCounter_t        TST_IVCounter;
    CRYS_AES_OperationMode_t    TST_OperationMode;
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataInSize;         
    DxUint8_t                   TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t                   TST_DataOutDecrypt[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} TST_ATP_SpecialDataOpAESTestDataStruct;

typedef struct TST_ATP_SpecialDataOpDESTestDataStruct{
    char                        TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxByte_t                    TST_DESKey1[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyType1;
    DxByte_t                    TST_DESKey2[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyType2;
    DxByte_t                    TST_DESKeyTemp[TST_AES_KEY_SIZE];
    SSTDESKeyType_t             TST_DESKeyTypeTemp;
    DxUint32_t                  TST_KeySizeInBytes;
    CRYS_DES_Iv_t               TST_IVCounter;
    CRYS_DES_OperationMode_t    TST_OperationMode;
    DxUint8_t                   TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataInSize;
    DxUint8_t                   TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t                   TST_DataOutDecrypt[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
} TST_ATP_SpecialDataOpDESTestDataStruct;




/*****************************************************************************
 * Function Name:                                                           
 *  SEPQA_SST_SpecialDataOpAES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Create a new AES shared key authenticator by calling: SST_ AuthenticatorAESSharedSecretCreate.
 *    4.    Open the authenticator by calling:
 *          i.      SST_AuthenticatorChallengeGet 
 *          ii.      CRYS_AES (Encrypt the challenge using the AES key)
 *          iii.  SST_AuthenticationOpen.
 *    5.  Close the transaction by calling: SST_TransactionClose.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new AES #1 key by calling: SST_AESKeyGenerate.
 *    8.  Read the generated AES key #1 by calling: SST_AESKeyRead.
 *    9.  Insert an AES #2 key to the SST by calling: SST_AESKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted AES key #2 by calling: SST_AESKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Encrypt plain text by using AES key #1 and calling: CRYS_SST_AES.
 *    13.  Decrypt the received cipher text using AES key #2 by calling: CRYS_SST_AES and compare to the original plain text.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the AES keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpAES ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_SpecialDataOpDES        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of a DES symmetric key.
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd.
 *    5.  Open the authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new DES #1 key by calling: SST_DESKeyGenerate.
 *    8.  Read the generated DES key #1 by calling: SST_DESKeyRead.
 *    9.  Insert a DES #2 key to the SST by calling: SST_DESKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted DES key #2 by calling: SST_DESKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Encrypt plain text by using DES key #1 and calling: CRYS_SST_DES.
 *    13.  Decrypt the received cipher text using DES key #2 by calling: CRYS_SST_DES and compare to the original plain text.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the DES keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpDES ( void );


#ifdef __cplusplus
}


#endif

#endif

